package com.qboxus.tictic.activitesfragments.profile

import android.content.Intent
import android.os.Bundle
import android.text.TextUtils
import android.view.View
import androidx.activity.result.ActivityResult
import androidx.activity.result.ActivityResultCallback
import androidx.activity.result.contract.ActivityResultContracts
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.ViewModelProvider
import com.qboxus.tictic.R
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.ActivitySubmitReportBinding
import com.qboxus.tictic.repositories.ReportRepository
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions.cancelLoader
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.isStringHasValue
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Functions.showLoader
import com.qboxus.tictic.simpleclasses.Functions.showToast
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.ReportFactory
import com.qboxus.tictic.viewModels.ReportViewModel

class SubmitReportActivity : AppCompatLocaleActivity(), View.OnClickListener {

    lateinit var reportId: String
    lateinit var txtReportType: String
    lateinit var videoId: String
    lateinit var userId: String
    lateinit var roomId: String
    lateinit var productId: String

    lateinit var binding:ActivitySubmitReportBinding
    lateinit var viewModel: ReportViewModel
    private val reportRepository = ReportRepository()


    var resultCallback = registerForActivityResult<Intent, ActivityResult>(
        ActivityResultContracts.StartActivityForResult(), object : ActivityResultCallback<ActivityResult?> {
            override fun onActivityResult(result: ActivityResult?) {
                if (result?.resultCode == RESULT_OK) {
                    val data = result.data
                    if (data!!.getBooleanExtra("isShow", false)) {
                        val report_reason = data.getStringExtra("reason")
                        binding.reportType.text = report_reason
                    }
                }
            }
        })

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(this@SubmitReportActivity).getString(
                Variables.APP_LANGUAGE_CODE,
                Variables.DEFAULT_LANGUAGE_CODE
            ), this, javaClass, false
        )
        binding=DataBindingUtil.setContentView(this,R.layout.activity_submit_report)


        val viewModelProviderFactory = ReportFactory(this,reportRepository)
        viewModel = ViewModelProvider(this,viewModelProviderFactory)[ReportViewModel::class.java]
        binding.lifecycleOwner = this

        reportId = intent.getStringExtra("report_id")?:""
        txtReportType = intent.getStringExtra("report_type")?:""
        videoId = intent.getStringExtra("video_id")?:""
        userId = intent.getStringExtra("user_id")?:""
        roomId = intent.getStringExtra("room_id")?:""
        productId = intent.getStringExtra("product_id")?:""


        binding.reportType.setText(txtReportType)
        binding.backBtn.setOnClickListener(this)
        binding.reportReasonLayout.setOnClickListener(this)
        binding.submitBtn.setOnClickListener(this)

        setObserveAble()
    }


    fun setObserveAble(){

        viewModel.reportLiveData.observe(this,{
            when(it){
                is ApiResponce.Loading ->{
                    showLoader(this@SubmitReportActivity, false, false)
                }
                is ApiResponce.Success ->{
                    showToast(
                        this@SubmitReportActivity,
                        getString(R.string.report_submitted_successfully)
                    )
                    moveBack()
                }

                is ApiResponce.Error ->{
                    cancelLoader()
                    showToast(this@SubmitReportActivity,it.message)

                }

                else -> {}
            }
        })


    }


    fun checkValidation(): Boolean {
        if (TextUtils.isEmpty(binding.reportType!!.text)) {
            showToast(this@SubmitReportActivity, getString(R.string.please_give_some_reason))
            return false
        }
        return true
    }


    private fun moveBack() {
        val intent = Intent()
        intent.putExtra("isShow", true)
        setResult(RESULT_OK, intent)
        finish()
    }


    override fun onClick(v: View) {
        when (v.id) {
            R.id.submit_btn -> if (isStringHasValue(videoId) && checkValidation()) {
                viewModel.reportVideo(
                    videoId,
                    reportId,
                    binding.reportDescriptionTxt.text.toString()
                )
            }

            else if (isStringHasValue(productId) && checkValidation()){
                viewModel.reportProduct(productId,reportId,binding.reportDescriptionTxt.text.toString())
            }
            else if (isStringHasValue(roomId) && checkValidation()) {
                viewModel.reportRoom(roomId,reportId,binding.reportDescriptionTxt.text.toString())
            }
            else if (isStringHasValue(userId) && checkValidation()) {
                viewModel.reportUser(userId,reportId,binding.reportDescriptionTxt.text.toString())
            }


            R.id.report_reason_layout -> {
                val intent = Intent(this@SubmitReportActivity, ReportTypeActivity::class.java)
                intent.putExtra("video_id", videoId)
                intent.putExtra("user_id", userId)
                intent.putExtra("isFrom", true)
                resultCallback.launch(intent)
                overridePendingTransition(R.anim.in_from_bottom, R.anim.out_to_top)
            }

            R.id.back_btn -> super@SubmitReportActivity.onBackPressed()
        }
    }
}